package ch.frankel.blog.hibernate;

import static org.testng.Assert.assertNotSame;

import org.hibernate.NonUniqueObjectException;
import org.hibernate.Session;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import ch.frankel.blog.hibernate.model.Customer;

/**
 * Test to check differences between <code>update()</code> and
 * <code>merge()</code>.
 * 
 * @author Nicolas Frnkel
 * @since 31 march 2011
 */
public class TestPart7 extends AbstractTest {

	/**
	 * Opens transaction.
	 */
	@BeforeClass(dependsOnMethods = "setUpFactory")
	protected void beginTransaction() {

		factory.getCurrentSession().beginTransaction();
	}

	/**
	 * Rollbacks transaction.
	 */
	@AfterClass
	protected void rollback() {

		factory.getCurrentSession().getTransaction().rollback();
	}

	@Test
	public void testUpdate() {

		Session session = factory.getCurrentSession();

		Customer customer = (Customer) session.get(Customer.class, 1L);

		session.getTransaction().commit();

		customer.setFirstName("John");

		beginTransaction();

		session = factory.getCurrentSession();

		session.update(customer);
	}

	@Test(expectedExceptions = NonUniqueObjectException.class)
	public void testUpdateThrowsNonUniqueObjectException() {

		Session session = factory.getCurrentSession();

		Customer customer = (Customer) session.get(Customer.class, 1L);

		session.getTransaction().commit();

		customer.setFirstName("John");

		beginTransaction();

		session = factory.getCurrentSession();

		session.get(Customer.class, 1L);

		// Fail here
		session.update(customer);
	}

	@Test
	public void testMerge() {

        Session session = factory.getCurrentSession();
        
        Customer customer = (Customer) session.get(Customer.class, 1L);
        
        session.getTransaction().commit();
        
        customer.setFirstName("John");
        
        beginTransaction();
        
        session = factory.getCurrentSession();
        
        session.get(Customer.class, 1L);
        
        Customer mergedCustomer = (Customer) session.merge(customer);
        
        assertNotSame(mergedCustomer, customer);
	}
}
